/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.blockentity.barrel.mode;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;
import novamachina.exnihilosequentia.common.blockentity.barrel.AbstractBarrelEntity;
import novamachina.exnihilosequentia.common.blockentity.barrel.mode.AbstractBarrelMode;
import novamachina.exnihilosequentia.common.item.DollItem;
import novamachina.exnihilosequentia.common.utility.Config;
import novamachina.exnihilosequentia.common.utility.StringUtils;

public class MobSpawnBarrelMode
extends AbstractBarrelMode {
    @Nonnull
    private static final String CURRENT_PROGRESS_TAG = "currentProgress";
    @Nonnull
    private static final String DOLL_TYPE_TAG = "dollType";
    private int currentProgress = 0;
    @Nullable
    private DollItem doll = null;

    public MobSpawnBarrelMode(@Nonnull String name) {
        super(name);
    }

    public void setDoll(@Nullable DollItem doll) {
        this.doll = doll;
    }

    @Override
    public void tick(@Nonnull AbstractBarrelEntity barrelTile) {
        if (this.doll == null) {
            return;
        }
        ++this.currentProgress;
        this.spawnParticle(barrelTile);
        if (this.currentProgress >= Config.getSecondsToSpawn() * 20 && this.doll.spawnMob(barrelTile.m_58904_(), barrelTile.m_58899_())) {
            barrelTile.getTank().setFluid(FluidStack.EMPTY);
            barrelTile.setMode("empty");
        }
    }

    @Override
    @Nonnull
    public InteractionResult onBlockActivated(@Nonnull AbstractBarrelEntity barrelTile, @Nonnull Player player, @Nonnull InteractionHand handIn, @Nonnull IFluidHandler fluidHandler, @Nonnull IItemHandler itemHandler) {
        return InteractionResult.SUCCESS;
    }

    @Override
    public boolean canFillWithFluid(@Nonnull AbstractBarrelEntity barrel) {
        return false;
    }

    @Override
    public boolean isEmptyMode() {
        return false;
    }

    @Override
    protected boolean isTriggerItem(@Nonnull ItemStack stack) {
        return false;
    }

    @Override
    public void read(@Nonnull CompoundTag nbt) {
        this.currentProgress = nbt.m_128441_(CURRENT_PROGRESS_TAG) ? nbt.m_128451_(CURRENT_PROGRESS_TAG) : 0;
        this.doll = nbt.m_128441_(DOLL_TYPE_TAG) ? (DollItem)ForgeRegistries.ITEMS.getValue(new ResourceLocation(nbt.m_128461_(DOLL_TYPE_TAG))) : null;
    }

    @Override
    @Nonnull
    public CompoundTag write() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_(CURRENT_PROGRESS_TAG, this.currentProgress);
        if (this.doll != null) {
            nbt.m_128359_(DOLL_TYPE_TAG, this.doll.getRegistryName().toString());
        }
        return nbt;
    }

    @Override
    protected void spawnParticle(@Nonnull AbstractBarrelEntity barrelTile) {
        Level world = barrelTile.m_58904_();
        if (!(world instanceof ServerLevel)) {
            return;
        }
        ((ServerLevel)world).m_8767_((ParticleOptions)ParticleTypes.f_123755_, (double)barrelTile.m_58899_().m_123341_() + barrelTile.m_58904_().f_46441_.nextDouble(), (double)barrelTile.m_58899_().m_123342_() + barrelTile.m_58904_().f_46441_.nextDouble(), (double)barrelTile.m_58899_().m_123343_() + barrelTile.m_58904_().f_46441_.nextDouble(), 5, 0.0, 0.0, 0.0, 0.05);
    }

    @Override
    @Nonnull
    public List<Component> getWailaInfo(@Nonnull AbstractBarrelEntity barrelTile) {
        ArrayList<Component> info = new ArrayList<Component>();
        info.add((Component)new TranslatableComponent("waila.progress", new Object[]{StringUtils.formatPercent(Float.valueOf((float)this.currentProgress / (float)(Config.getSecondsToSpawn() * 20)))}));
        return info;
    }

    @Override
    @Nonnull
    public ItemStack handleInsert(@Nonnull AbstractBarrelEntity barrelTile, @Nonnull ItemStack stack, boolean simulate) {
        return stack;
    }
}

